using System;
using System.Collections.Generic;
using System.Linq;

class Point
{
    public int x, y;
    public Point(int x, int y) { this.x = x; this.y = y; }
}

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var points = new Point[n];
        var countX = new Dictionary<int, long>();
        var countY = new Dictionary<int, long>();
        for (int i = 0; i < n; i++)
        {
            var arr = Console.ReadLine().Split().Select(int.Parse).ToArray();
            points[i] = new Point(arr[0], arr[1]);
            if (!countX.ContainsKey(arr[0])) { countX[arr[0]] = 0; }
            countX[arr[0]]++;
            if (!countY.ContainsKey(arr[1])) { countY[arr[1]] = 0; }
            countY[arr[1]]++;
        }
        long result = 0;
        foreach (var kv in countX)
        {
            result += kv.Value * (kv.Value - 1) / 2;
        }
        foreach (var kv in countY)
        {
            result += kv.Value * (kv.Value - 1) / 2;
        }
        for (int i = 0; i < n; i++)
        {
            for (int j = i + 1; j < n; j++)
            {
                int dx = Math.Abs(points[i].x - points[j].x);
                int dy = Math.Abs(points[i].y - points[j].y);

                if (dx != 0 && dx == dy)
                {
                    result += 2;
                }
            }
        }
        Console.WriteLine(result);
    }
}